<?php $__env->startSection('content'); ?>
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-6 text-gray-900">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold">Parametres Generaux</h1>
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-indigo-600 hover:text-indigo-900">
                Retour au dashboard
            </a>
        </div>

        <?php if(session('success')): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('admin.settings.general.update')); ?>">
            <?php echo csrf_field(); ?>

            <div class="mb-6">
                <h2 class="text-lg font-semibold mb-4">Annee Academique et Inscriptions</h2>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="annee_academique" class="block text-sm font-medium text-gray-700 mb-1">Annee academique</label>
                        <input type="text" name="annee_academique" id="annee_academique"
                            value="<?php echo e($settings->annee_academique ?? '2025-2026'); ?>"
                            placeholder="2025-2026"
                            class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        <?php $__errorArgs = ['annee_academique'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="bg-gray-50 p-4 rounded-lg">
                    <div class="flex items-center mb-2">
                        <input type="checkbox" name="inscriptions_ouvertes" id="inscriptions_ouvertes" value="1"
                            <?php echo e($settings->inscriptions_ouvertes ? 'checked' : ''); ?>

                            class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500">
                        <label for="inscriptions_ouvertes" class="ml-2 text-sm font-medium text-gray-700">
                            Inscriptions ouvertes
                        </label>
                    </div>
                    <p class="text-sm text-gray-500">
                        Si desactive, le message "Inscriptions cloturees" sera affiche sur le site.
                    </p>
                </div>
            </div>

            <div>
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded transition">
                    Enregistrer
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\istmat\resources\views/admin/settings/general.blade.php ENDPATH**/ ?>