<?php $__env->startSection('content'); ?>
<!-- Hero Slider -->
<section class="relative bg-slate-900 overflow-hidden">
    <div id="hero-slider" class="relative h-[500px] md:h-[550px]">
        <!-- Slide 1: Bienvenue -->
        <div class="slide absolute inset-0 flex items-center justify-center opacity-100 transition-opacity duration-500" data-slide="0">
            <video class="absolute inset-0 w-full h-full object-cover" autoplay muted loop playsinline>
                <source src="<?php echo e(asset('videos/hero-1.mp4')); ?>" type="video/mp4">
            </video>
            <div class="absolute inset-0 bg-black/57"></div>
            <div class="text-center px-4 max-w-4xl mx-auto relative z-10">
                <img src="<?php echo e(asset('images/logo-istmad.png')); ?>" alt="Logo ISTMAD" class="h-24 mx-auto mb-6" onerror="this.style.display='none'">
                <h1 class="text-3xl md:text-5xl font-bold text-white mb-4">Bienvenue à ISTMAD</h1>
                <p class="text-lg text-white/90 mb-8">Institut Supérieur de Technologie et du Management Appliqué au Développement</p>
                <a href="<?php echo e(route('a-propos')); ?>" class="px-8 py-3 bg-sky-600 text-white font-medium rounded-lg hover:bg-sky-700 transition">
                    Découvrir l'institut
                </a>
            </div>
        </div>

        <!-- Slide 2: Programmes -->
        <div class="slide absolute inset-0 flex items-center justify-center opacity-0 transition-opacity duration-500" data-slide="1">
            <video class="absolute inset-0 w-full h-full object-cover" autoplay muted loop playsinline>
                <source src="<?php echo e(asset('videos/hero-2.mp4')); ?>" type="video/mp4">
            </video>
            <div class="absolute inset-0 bg-black/57"></div>
            <div class="text-center px-4 max-w-4xl mx-auto relative z-10">
                <div class="flex justify-center gap-3 mb-6">
                    <span class="px-4 py-2 bg-slate-900 text-white text-sm font-medium rounded-lg">BTS</span>
                    <span class="px-4 py-2 bg-red-600 text-white text-sm font-medium rounded-lg">HND</span>
                </div>
                <h2 class="text-3xl md:text-5xl font-bold text-white mb-4">Des formations professionnalisantes et reconnues</h2>
                <p class="text-lg text-white/90 mb-8">Des filières BTS et HND conçues pour répondre aux exigences du marché de l'emploi</p>
                <a href="<?php echo e(route('programmes')); ?>" class="px-8 py-3 bg-sky-600 text-white font-medium rounded-lg hover:bg-sky-700 transition">
                    Voir nos filières
                </a>
            </div>
        </div>

        <!-- Slide 3: Inscriptions -->
        <div class="slide absolute inset-0 flex items-center justify-center opacity-0 transition-opacity duration-500" data-slide="2">
            <video class="absolute inset-0 w-full h-full object-cover" autoplay muted loop playsinline>
                <source src="<?php echo e(asset('videos/hero-3.mp4')); ?>" type="video/mp4">
            </video>
            <div class="absolute inset-0 bg-black/57"></div>
            <div class="text-center px-4 max-w-4xl mx-auto relative z-10">
                <h2 class="text-3xl md:text-5xl font-bold text-white mb-4">Inscriptions – Année académique <?php echo e($settings->annee_academique ?? '2025-2026'); ?></h2>
                <?php if($settings && $settings->inscriptions_ouvertes): ?>
                    <p class="text-lg text-white mb-8">Les inscriptions sont ouvertes</p>
                    <a href="<?php echo e(route('inscription')); ?>" class="px-8 py-3 bg-red-600 text-white font-medium rounded-lg hover:bg-red-600/90 transition">
                        S'inscrire maintenant
                    </a>
                <?php else: ?>
                    <p class="text-lg text-white mb-8">Les inscriptions sont clôturées</p>
                    <a href="<?php echo e(route('contact')); ?>" class="px-8 py-3 bg-sky-600 text-white font-medium rounded-lg hover:bg-sky-700 transition">
                        Nous contacter
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <!-- Slide 4: Excellence -->
        <div class="slide absolute inset-0 flex items-center justify-center opacity-0 transition-opacity duration-500" data-slide="3">
            <video class="absolute inset-0 w-full h-full object-cover" autoplay muted loop playsinline>
                <source src="<?php echo e(asset('videos/hero-4.mp4')); ?>" type="video/mp4">
            </video>
            <div class="absolute inset-0 bg-black/57"></div>
            <div class="text-center px-4 max-w-4xl mx-auto relative z-10">
                <h2 class="text-3xl md:text-5xl font-bold text-white mb-4">Exigence académique et encadrement pédagogique</h2>
                <p class="text-lg text-white/90 mb-8">Un suivi structuré pour accompagner chaque étudiant vers la réussite</p>
                <a href="<?php echo e(route('a-propos')); ?>" class="px-8 py-3 bg-sky-600 text-white font-medium rounded-lg hover:bg-sky-700 transition">
                    Notre pédagogie
                </a>
            </div>
        </div>

        <!-- Slide 5: Contact -->
        <div class="slide absolute inset-0 flex items-center justify-center opacity-0 transition-opacity duration-500" data-slide="4">
            <video class="absolute inset-0 w-full h-full object-cover" autoplay muted loop playsinline>
                <source src="<?php echo e(asset('videos/hero-5.mp4')); ?>" type="video/mp4">
            </video>
            <div class="absolute inset-0 bg-black/57"></div>
            <div class="text-center px-4 max-w-4xl mx-auto relative z-10">
                <h2 class="text-3xl md:text-5xl font-bold text-white mb-4">Une question sur votre orientation ?</h2>
                <p class="text-lg text-white/90 mb-8">Notre équipe est disponible pour vous accompagner</p>
                <a href="<?php echo e(route('contact')); ?>" class="px-8 py-3 bg-sky-600 text-white font-medium rounded-lg hover:bg-sky-700 transition">
                    Contactez-nous
                </a>
            </div>
        </div>

        <!-- Navigation dots -->
        <div class="absolute bottom-6 left-0 right-0 flex justify-center gap-2">
            <button class="slider-dot w-3 h-3 rounded-full bg-white opacity-100" data-slide="0"></button>
            <button class="slider-dot w-3 h-3 rounded-full bg-white opacity-50" data-slide="1"></button>
            <button class="slider-dot w-3 h-3 rounded-full bg-white opacity-50" data-slide="2"></button>
            <button class="slider-dot w-3 h-3 rounded-full bg-white opacity-50" data-slide="3"></button>
            <button class="slider-dot w-3 h-3 rounded-full bg-white opacity-50" data-slide="4"></button>
        </div>

        <!-- Navigation arrows -->
        <button id="prev-slide" class="absolute left-4 top-1/2 -translate-y-1/2 w-10 h-10 bg-white/20 rounded-full flex items-center justify-center hover:bg-white/30 transition">
            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
        </button>
        <button id="next-slide" class="absolute right-4 top-1/2 -translate-y-1/2 w-10 h-10 bg-white/20 rounded-full flex items-center justify-center hover:bg-white/30 transition">
            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
            </svg>
        </button>
    </div>
</section>

<!-- Section Excellence Academique -->
<section class="py-16 bg-slate-50">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <div>
                <h2 class="text-2xl sm:text-3xl font-bold text-slate-900 mb-6">
                    Une institution au service de la formation professionnelle
                </h2>
                <p class="text-slate-600 leading-relaxed mb-4 text-justify">
                    L'Institut Supérieur de Technologie et du Management Appliqué au Développement (ISTMAD) est un établissement d'enseignement supérieur qui forme des étudiants dans des filières professionnelles adaptées aux réalités du monde du travail.
                </p>
                <p class="text-slate-600 leading-relaxed mb-6 text-justify">
                    Nos formations BTS et HND reposent sur un équilibre entre enseignements théoriques, pratiques professionnelles et accompagnement pédagogique, afin de préparer des profils compétents, responsables et opérationnels.
                </p>
                <a href="<?php echo e(route('a-propos')); ?>" class="inline-flex items-center text-sky-600 font-medium hover:text-sky-600/80 transition">
                    En savoir plus sur ISTMAD
                    <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
            </div>
            <div class="bg-slate-50 rounded-xl h-80 flex items-center justify-center">
                <img src="<?php echo e(asset('images/istmat-campus.jpg')); ?>" alt="Campus ISTMAT" class="w-full h-full object-cover rounded-xl" onerror="this.parentElement.innerHTML='<div class=\'text-center text-slate-500\'><svg class=\'w-16 h-16 mx-auto mb-2\' fill=\'none\' stroke=\'currentColor\' viewBox=\'0 0 24 24\'><path stroke-linecap=\'round\' stroke-linejoin=\'round\' stroke-width=\'2\' d=\'M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4\'/></svg><span>Image Campus ISTMAT</span></div>'">
            </div>
        </div>
    </div>
</section>

<!-- Apercu des Filieres -->
<section class="py-16 bg-white">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-2xl sm:text-3xl font-bold text-slate-900 mb-3">Nos filières de formation</h2>
            <p class="text-slate-600 max-w-xl mx-auto">
                Des parcours professionnels structurés et orientés compétences
            </p>
        </div>

        <?php if($filieres->count() > 0): ?>
            <div class="grid md:grid-cols-3 gap-6 mb-10">
                <?php $__currentLoopData = $filieres->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $filiere): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white border border-slate-200 rounded-xl p-6 hover:border-sky-600 transition">
                        <div class="flex items-center gap-2 mb-4">
                            <span class="px-2 py-1 bg-sky-100 text-sky-600 text-xs font-medium rounded">BTS</span>
                            <span class="text-slate-600 text-sm">Durée : 2 ans</span>
                        </div>
                        <h3 class="text-lg font-semibold text-slate-900 mb-2"><?php echo e($filiere->nom); ?></h3>
                        <p class="text-slate-600 text-sm mb-4 line-clamp-2"><?php echo e(Str::limit($filiere->description, 100)); ?></p>
                        <div class="flex items-center justify-between">
                            <span class="text-sky-600 font-semibold"><?php echo e($filiere->niveaux->count()); ?> niveau(x)</span>
                            <a href="<?php echo e(route('programmes')); ?>" class="text-sm text-red-600 font-medium hover:text-red-600/80">
                                Voir les détails
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="text-center py-8 text-slate-600">
                Les filières seront bientôt disponibles.
            </div>
        <?php endif; ?>

        <div class="text-center">
            <a href="<?php echo e(route('programmes')); ?>" class="inline-flex items-center px-6 py-3 border border-sky-600 text-sky-600 font-medium rounded-lg hover:bg-sky-100 transition">
                Voir toutes les filières
                <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                </svg>
            </a>
        </div>
    </div>
</section>

<!-- Section Valeurs -->
<section class="py-16 bg-slate-50">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <!-- Image a gauche -->
            <div class="bg-slate-50 rounded-xl h-80 flex items-center justify-center order-2 lg:order-1">
                <img src="<?php echo e(asset('images/istmat-valeurs.jpg')); ?>" alt="Valeurs ISTMAT" class="w-full h-full object-cover rounded-xl" onerror="this.parentElement.innerHTML='<div class=\'text-center text-slate-500\'><svg class=\'w-16 h-16 mx-auto mb-2\' fill=\'none\' stroke=\'currentColor\' viewBox=\'0 0 24 24\'><path stroke-linecap=\'round\' stroke-linejoin=\'round\' stroke-width=\'2\' d=\'M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253\'/></svg><span>Image Valeurs ISTMAT</span></div>'">
            </div>

            <!-- Valeurs en grille 2x2 a droite -->
            <div class="order-1 lg:order-2">
                <h2 class="text-2xl sm:text-3xl font-bold text-slate-900 mb-8">Nos valeurs</h2>
                <div class="grid grid-cols-2 gap-4">
                    <div class="bg-white rounded-xl p-5 border border-slate-200">
                        <div class="w-10 h-10 bg-sky-100 rounded-lg flex items-center justify-center mb-3">
                            <svg class="w-5 h-5 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"/>
                            </svg>
                        </div>
                        <h3 class="font-semibold text-slate-900 mb-1">Excellence</h3>
                        <p class="text-sm text-slate-600 text-justify">Nous plaçons la qualité de l'enseignement et la rigueur académique au cœur de notre mission.</p>
                    </div>

                    <div class="bg-white rounded-xl p-5 border border-slate-200">
                        <div class="w-10 h-10 bg-sky-100 rounded-lg flex items-center justify-center mb-3">
                            <svg class="w-5 h-5 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                            </svg>
                        </div>
                        <h3 class="font-semibold text-slate-900 mb-1">Intégrité</h3>
                        <p class="text-sm text-slate-600 text-justify">Nous agissons avec responsabilité, transparence et respect des principes éthiques.</p>
                    </div>

                    <div class="bg-white rounded-xl p-5 border border-slate-200">
                        <div class="w-10 h-10 bg-sky-100 rounded-lg flex items-center justify-center mb-3">
                            <svg class="w-5 h-5 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                            </svg>
                        </div>
                        <h3 class="font-semibold text-slate-900 mb-1">Innovation</h3>
                        <p class="text-sm text-slate-600 text-justify">Nous adaptons nos méthodes pédagogiques aux évolutions des métiers et des technologies.</p>
                    </div>

                    <div class="bg-white rounded-xl p-5 border border-slate-200">
                        <div class="w-10 h-10 bg-sky-100 rounded-lg flex items-center justify-center mb-3">
                            <svg class="w-5 h-5 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                            </svg>
                        </div>
                        <h3 class="font-semibold text-slate-900 mb-1">Accompagnement</h3>
                        <p class="text-sm text-slate-600 text-justify">Chaque étudiant bénéficie d'un suivi pédagogique structuré tout au long de son parcours.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Bandeau CTA Final Dynamique -->
<section class="py-12 bg-blue-900">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <?php if($settings && $settings->inscriptions_ouvertes): ?>
            <h2 class="text-2xl sm:text-3xl font-bold text-white mb-4">
                Inscriptions ouvertes – Année académique <?php echo e($settings->annee_academique ?? '2025-2026'); ?>

            </h2>
            <p class="text-white/90 mb-8 max-w-2xl mx-auto">
                Rejoignez ISTMAD et engagez-vous dans une formation professionnelle orientée compétences et employabilité.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?php echo e(route('inscription')); ?>" class="px-8 py-3 bg-red-600 text-white font-medium rounded-lg hover:bg-red-600/90 transition">
                    Déposer ma candidature
                </a>
                <a href="<?php echo e(route('contact')); ?>" class="px-8 py-3 bg-transparent border-2 border-white text-white font-medium rounded-lg hover:bg-white/10 transition">
                    Nous contacter
                </a>
            </div>
        <?php else: ?>
            <h2 class="text-2xl sm:text-3xl font-bold text-white mb-4">
                Inscriptions clôturées – Année académique <?php echo e($settings->annee_academique ?? '2025-2026'); ?>

            </h2>
            <p class="text-white/90 mb-8 max-w-2xl mx-auto">
                Les inscriptions pour cette année académique sont terminées. Contactez-nous pour plus d'informations sur la prochaine session.
            </p>
            <a href="<?php echo e(route('contact')); ?>" class="px-8 py-3 bg-sky-600 text-white font-medium rounded-lg hover:bg-sky-700 transition">
                Nous contacter
            </a>
        <?php endif; ?>
    </div>
</section>

<!-- Script Slider -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    let currentSlide = 0;
    const slides = document.querySelectorAll('.slide');
    const dots = document.querySelectorAll('.slider-dot');
    const totalSlides = slides.length;

    function showSlide(index) {
        slides.forEach((slide, i) => {
            slide.classList.toggle('opacity-100', i === index);
            slide.classList.toggle('opacity-0', i !== index);
        });
        dots.forEach((dot, i) => {
            dot.classList.toggle('opacity-100', i === index);
            dot.classList.toggle('opacity-50', i !== index);
        });
        currentSlide = index;
    }

    function nextSlide() {
        showSlide((currentSlide + 1) % totalSlides);
    }

    function prevSlide() {
        showSlide((currentSlide - 1 + totalSlides) % totalSlides);
    }

    document.getElementById('next-slide').addEventListener('click', nextSlide);
    document.getElementById('prev-slide').addEventListener('click', prevSlide);

    dots.forEach((dot, i) => {
        dot.addEventListener('click', () => showSlide(i));
    });

    setInterval(nextSlide, 5000);
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\istmat\resources\views/front/accueil.blade.php ENDPATH**/ ?>