<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\FrontController;
use App\Http\Controllers\Front\GalleryController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\InscriptionController;
use App\Http\Controllers\Admin\MessageController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\StatisticController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\DocumentRequisController;
use App\Http\Controllers\Admin\FiliereController;
use App\Http\Controllers\Admin\NiveauController;
use App\Http\Controllers\Admin\MatiereController;
use App\Http\Controllers\Admin\FraisController;
use App\Http\Controllers\Admin\DocumentNiveauController;
use App\Http\Controllers\Admin\GalleryController as AdminGalleryController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Routes publiques Front-office
Route::get('/', [FrontController::class, 'accueil'])->name('accueil');
Route::get('/a-propos', [FrontController::class, 'aPropos'])->name('a-propos');
Route::get('/programmes', [FrontController::class, 'programmes'])->name('programmes');
Route::get('/galerie', [GalleryController::class, 'index'])->name('galerie');
Route::get('/inscription', [FrontController::class, 'inscription'])->name('inscription');
Route::post('/inscription', [FrontController::class, 'inscriptionStore'])->name('inscription.store');
Route::get('/contact', [FrontController::class, 'contact'])->name('contact');
Route::post('/contact', [FrontController::class, 'contactStore'])->name('contact.store');

// Routes Admin protégées par authentification
Route::middleware('auth')->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/inscriptions', [InscriptionController::class, 'index'])->name('inscriptions.index');
    Route::get('/inscriptions/{inscription}', [InscriptionController::class, 'show'])->name('inscriptions.show');
    Route::patch('/inscriptions/{inscription}/statut', [InscriptionController::class, 'updateStatut'])->name('inscriptions.updateStatut');
    Route::get('/messages', [MessageController::class, 'index'])->name('messages.index');
    Route::get('/messages/{message}', [MessageController::class, 'show'])->name('messages.show');
    Route::post('/messages/{message}/repondre', [MessageController::class, 'repondre'])->name('messages.repondre');
    Route::get('/settings/email', [SettingController::class, 'email'])->name('settings.email');
    Route::post('/settings/email', [SettingController::class, 'emailUpdate'])->name('settings.email.update');
    Route::get('/settings/general', [SettingController::class, 'general'])->name('settings.general');
    Route::post('/settings/general', [SettingController::class, 'generalUpdate'])->name('settings.general.update');
    Route::resource('statistics', StatisticController::class);
    Route::resource('faqs', FaqController::class);
    Route::resource('documents', DocumentRequisController::class);

    // Gestion des Filieres et structure academique
    Route::get('/filieres/{filiere}/configure', [FiliereController::class, 'configure'])->name('filieres.configure');
    Route::resource('filieres', FiliereController::class);
    Route::get('/niveaux/{niveau}/edit', [NiveauController::class, 'edit'])->name('niveaux.edit');
    Route::put('/niveaux/{niveau}', [NiveauController::class, 'update'])->name('niveaux.update');
    Route::get('/niveaux/{niveau}/matieres/create', [MatiereController::class, 'create'])->name('matieres.create');
    Route::post('/niveaux/{niveau}/matieres', [MatiereController::class, 'store'])->name('matieres.store');
    Route::get('/matieres/{matiere}/edit', [MatiereController::class, 'edit'])->name('matieres.edit');
    Route::put('/matieres/{matiere}', [MatiereController::class, 'update'])->name('matieres.update');
    Route::delete('/matieres/{matiere}', [MatiereController::class, 'destroy'])->name('matieres.destroy');
    Route::get('/niveaux/{niveau}/frais/edit', [FraisController::class, 'edit'])->name('frais.edit');
    Route::put('/niveaux/{niveau}/frais', [FraisController::class, 'update'])->name('frais.update');
    Route::get('/niveaux/{niveau}/documents/create', [DocumentNiveauController::class, 'create'])->name('documents-niveau.create');
    Route::post('/niveaux/{niveau}/documents', [DocumentNiveauController::class, 'store'])->name('documents-niveau.store');
    Route::get('/documents-niveau/{documentNiveau}/edit', [DocumentNiveauController::class, 'edit'])->name('documents-niveau.edit');
    Route::put('/documents-niveau/{documentNiveau}', [DocumentNiveauController::class, 'update'])->name('documents-niveau.update');
    Route::delete('/documents-niveau/{documentNiveau}', [DocumentNiveauController::class, 'destroy'])->name('documents-niveau.destroy');

    // Gestion de la Galerie
    Route::resource('galerie', AdminGalleryController::class);
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
