@extends('layouts.front')

@section('content')
<!-- Page Header -->
<section class="bg-gradient-to-r from-blue-900 to-blue-800 py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <h1 class="text-4xl sm:text-5xl font-bold text-white mb-4">Contactez-nous</h1>
            <p class="text-lg text-white/90 max-w-2xl mx-auto">
                Une question ? Notre équipe est à votre écoute
            </p>
        </div>
    </div>
</section>

<!-- Contact Section -->
<section class="py-16 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-3 gap-8">
            <!-- Contact Info Column -->
            <div class="lg:col-span-1 space-y-6">
                <!-- Address Card -->
                <div class="bg-white rounded-2xl shadow-sm p-6">
                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-sky-100 rounded-xl flex items-center justify-center flex-shrink-0">
                            <svg class="w-6 h-6 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-bold text-slate-900 mb-1">Notre adresse</h3>
                            <p class="text-slate-600 text-sm">Akwa Ngodi – Derrière le Cimetière<br>Immeuble MAD, Douala</p>
                        </div>
                    </div>
                </div>

                <!-- Phone Card -->
                <div class="bg-white rounded-2xl shadow-sm p-6">
                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-sky-100 rounded-xl flex items-center justify-center flex-shrink-0">
                            <svg class="w-6 h-6 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-bold text-slate-900 mb-1">Téléphone</h3>
                            <p class="text-slate-600 text-sm">+237 675 65 81 65<br>+237 673 759 828<br>+237 233 42 27 67</p>
                        </div>
                    </div>
                </div>

                <!-- Email Card -->
                <div class="bg-white rounded-2xl shadow-sm p-6">
                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-sky-100 rounded-xl flex items-center justify-center flex-shrink-0">
                            <svg class="w-6 h-6 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-bold text-slate-900 mb-1">Email</h3>
                            <p class="text-slate-600 text-sm">infos@istmad.com</p>
                        </div>
                    </div>
                </div>

                <!-- Hours Card -->
                <div class="bg-white rounded-2xl shadow-sm p-6">
                    <div class="flex items-start gap-4">
                        <div class="w-12 h-12 bg-sky-100 rounded-xl flex items-center justify-center flex-shrink-0">
                            <svg class="w-6 h-6 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-bold text-slate-900 mb-1">Horaires</h3>
                            <p class="text-slate-600 text-sm">Lun - Ven: 8h00 - 17h00<br>Sam: 8h00 - 12h00</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Form Column -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-2xl shadow-sm p-8">
                    <div class="mb-8">
                        <h2 class="text-2xl font-bold text-slate-900 mb-2">Envoyez-nous un message</h2>
                        <p class="text-slate-600">Remplissez le formulaire ci-dessous et nous vous répondrons dans les meilleurs délais.</p>
                    </div>

                    @if(session('success'))
                        <div class="bg-green-50 border border-green-200 rounded-xl p-4 mb-6 flex items-start gap-3">
                            <div class="flex-shrink-0">
                                <svg class="w-6 h-6 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="font-semibold text-green-800">Message envoyé avec succès !</h3>
                                <p class="text-green-700 text-sm mt-1">{{ session('success') }}</p>
                            </div>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('contact.store') }}" class="space-y-6">
                        @csrf

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="nom" class="block text-sm font-medium text-slate-900 mb-2">Nom complet <span class="text-red-500">*</span></label>
                                <input type="text" name="nom" id="nom" value="{{ old('nom') }}" required
                                    class="w-full px-4 py-3 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition @error('nom') border-red-500 @enderror"
                                    placeholder="Votre nom">
                                @error('nom')
                                    <p class="mt-2 text-sm text-red-500 flex items-center gap-1">
                                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>

                            <div>
                                <label for="email" class="block text-sm font-medium text-slate-900 mb-2">Email <span class="text-red-500">*</span></label>
                                <input type="email" name="email" id="email" value="{{ old('email') }}" required
                                    class="w-full px-4 py-3 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition @error('email') border-red-500 @enderror"
                                    placeholder="votre@email.com">
                                @error('email')
                                    <p class="mt-2 text-sm text-red-500 flex items-center gap-1">
                                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>
                        </div>

                        <div>
                            <label for="sujet" class="block text-sm font-medium text-slate-900 mb-2">Sujet <span class="text-red-500">*</span></label>
                            <input type="text" name="sujet" id="sujet" value="{{ old('sujet') }}" required
                                class="w-full px-4 py-3 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition @error('sujet') border-red-500 @enderror"
                                placeholder="Objet de votre message">
                            @error('sujet')
                                <p class="mt-2 text-sm text-red-500 flex items-center gap-1">
                                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                    {{ $message }}
                                </p>
                            @enderror
                        </div>

                        <div>
                            <label for="message" class="block text-sm font-medium text-slate-900 mb-2">Message <span class="text-red-500">*</span></label>
                            <textarea name="message" id="message" rows="6" required
                                class="w-full px-4 py-3 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition resize-none @error('message') border-red-500 @enderror"
                                placeholder="Écrivez votre message ici...">{{ old('message') }}</textarea>
                            @error('message')
                                <p class="mt-2 text-sm text-red-500 flex items-center gap-1">
                                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                    {{ $message }}
                                </p>
                            @enderror
                        </div>

                        <div class="pt-2">
                            <button type="submit" class="w-full bg-blue-900 hover:bg-blue-900/90 text-white font-semibold py-4 px-6 rounded-xl transition flex items-center justify-center gap-2 group">
                                <span>Envoyer le message</span>
                                <svg class="w-5 h-5 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/>
                                </svg>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Map Section -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <span class="text-sky-600 font-semibold text-sm uppercase tracking-wider">Localisation</span>
            <h2 class="text-3xl font-bold text-slate-900 mt-2">Comment nous trouver</h2>
        </div>
        <div class="bg-slate-50 rounded-2xl h-80 flex items-center justify-center">
            <div class="text-center">
                <svg class="w-16 h-16 text-slate-600 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
                <p class="text-slate-600">Carte Google Maps<br><span class="text-sm">(Intégrer l'iframe de localisation)</span></p>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Quick -->
@if($faqs->count() > 0)
<section class="py-16 bg-slate-50">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <span class="text-sky-600 font-semibold text-sm uppercase tracking-wider">FAQ</span>
            <h2 class="text-3xl font-bold text-slate-900 mt-2">Questions fréquentes</h2>
        </div>
        <div class="space-y-4">
            @foreach($faqs as $faq)
            <div class="bg-white rounded-xl p-6 shadow-sm">
                <h3 class="font-bold text-slate-900 mb-2">{{ $faq->question }}</h3>
                <p class="text-slate-600 text-sm">{{ $faq->reponse }}</p>
            </div>
            @endforeach
        </div>
        <div class="text-center mt-8">
            <a href="{{ route('inscription') }}" class="inline-flex items-center gap-2 px-6 py-3 bg-blue-900 text-white font-semibold rounded-xl hover:bg-blue-900/90 transition">
                <span>S'inscrire maintenant</span>
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                </svg>
            </a>
        </div>
    </div>
</section>
@endif
@endsection
