@extends('layouts.admin')

@section('content')
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-6 text-gray-900">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold">Parametres Generaux</h1>
            <a href="{{ route('admin.dashboard') }}" class="text-indigo-600 hover:text-indigo-900">
                Retour au dashboard
            </a>
        </div>

        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                {{ session('success') }}
            </div>
        @endif

        <form method="POST" action="{{ route('admin.settings.general.update') }}">
            @csrf

            <div class="mb-6">
                <h2 class="text-lg font-semibold mb-4">Annee Academique et Inscriptions</h2>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="annee_academique" class="block text-sm font-medium text-gray-700 mb-1">Annee academique</label>
                        <input type="text" name="annee_academique" id="annee_academique"
                            value="{{ $settings->annee_academique ?? '2025-2026' }}"
                            placeholder="2025-2026"
                            class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        @error('annee_academique')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <div class="bg-gray-50 p-4 rounded-lg">
                    <div class="flex items-center mb-2">
                        <input type="checkbox" name="inscriptions_ouvertes" id="inscriptions_ouvertes" value="1"
                            {{ $settings->inscriptions_ouvertes ? 'checked' : '' }}
                            class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500">
                        <label for="inscriptions_ouvertes" class="ml-2 text-sm font-medium text-gray-700">
                            Inscriptions ouvertes
                        </label>
                    </div>
                    <p class="text-sm text-gray-500">
                        Si desactive, le message "Inscriptions cloturees" sera affiche sur le site.
                    </p>
                </div>
            </div>

            <div>
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded transition">
                    Enregistrer
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
