@extends('layouts.admin')

@section('content')
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-6 text-gray-900">
        <div class="mb-6">
            <h1 class="text-3xl font-bold">Modifier le Niveau</h1>
            <p class="text-gray-500 mt-1">{{ $niveau->filiere->nom }}</p>
        </div>

        <form action="{{ route('admin.niveaux.update', $niveau) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="mb-4">
                <label for="nom" class="block text-sm font-medium text-gray-700 mb-2">Nom du niveau</label>
                <input type="text" name="nom" id="nom" value="{{ old('nom', $niveau->nom) }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('nom') border-red-500 @enderror">
                @error('nom')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="flex items-center">
                    <input type="hidden" name="statut" value="0">
                    <input type="checkbox" name="statut" value="1" {{ old('statut', $niveau->statut) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <span class="ml-2 text-sm text-gray-700">Niveau actif</span>
                </label>
            </div>

            <div class="flex items-center justify-between">
                <a href="{{ route('admin.filieres.show', $niveau->filiere_id) }}" class="text-gray-600 hover:text-gray-900">Annuler</a>
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                    Mettre a jour
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
