@extends('layouts.admin')

@section('content')
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-6 text-gray-900">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold">Détail de l'inscription</h1>
            <a href="{{ route('admin.inscriptions.index') }}" class="text-indigo-600 hover:text-indigo-900">
                Retour à la liste
            </a>
        </div>

        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                {{ session('success') }}
            </div>
        @endif

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <div class="bg-gray-50 p-4 rounded-lg">
                <h2 class="text-lg font-semibold mb-4">Informations personnelles</h2>
                <dl class="space-y-2">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Nom</dt>
                        <dd class="text-sm text-gray-900">{{ $inscription->nom }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Prénom</dt>
                        <dd class="text-sm text-gray-900">{{ $inscription->prenom }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Email</dt>
                        <dd class="text-sm text-gray-900">{{ $inscription->email }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Téléphone</dt>
                        <dd class="text-sm text-gray-900">{{ $inscription->telephone }}</dd>
                    </div>
                </dl>
            </div>

            <div class="bg-gray-50 p-4 rounded-lg">
                <h2 class="text-lg font-semibold mb-4">Informations inscription</h2>
                <dl class="space-y-2">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Filière souhaitée</dt>
                        <dd class="text-sm text-gray-900">{{ $inscription->filiere->nom ?? 'N/A' }} - {{ $inscription->niveau->nom ?? 'N/A' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Date d'inscription</dt>
                        <dd class="text-sm text-gray-900">{{ $inscription->created_at->format('d/m/Y à H:i') }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Statut actuel</dt>
                        <dd class="text-sm">
                            @if($inscription->statut === 'nouvelle')
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">Nouvelle</span>
                            @elseif($inscription->statut === 'traitee')
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">Traitée</span>
                            @else
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">Rejetée</span>
                            @endif
                        </dd>
                    </div>
                </dl>
            </div>
        </div>

        @if($inscription->message)
            <div class="bg-gray-50 p-4 rounded-lg mb-6">
                <h2 class="text-lg font-semibold mb-2">Message</h2>
                <p class="text-sm text-gray-900">{{ $inscription->message }}</p>
            </div>
        @endif

        <div class="bg-gray-50 p-4 rounded-lg">
            <h2 class="text-lg font-semibold mb-4">Changer le statut</h2>
            <form action="{{ route('admin.inscriptions.updateStatut', $inscription) }}" method="POST" class="flex items-center gap-4">
                @csrf
                @method('PATCH')
                <select name="statut" class="border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="nouvelle" {{ $inscription->statut === 'nouvelle' ? 'selected' : '' }}>Nouvelle</option>
                    <option value="traitee" {{ $inscription->statut === 'traitee' ? 'selected' : '' }}>Traitée</option>
                    <option value="rejetee" {{ $inscription->statut === 'rejetee' ? 'selected' : '' }}>Rejetée</option>
                </select>
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded transition">
                    Mettre à jour
                </button>
            </form>
        </div>
    </div>
</div>
@endsection
