@extends('layouts.admin')

@section('content')
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
    <div class="p-6 text-gray-900">
        <div class="flex justify-between items-center mb-4">
            <div>
                <h1 class="text-3xl font-bold">{{ $filiere->nom }}</h1>
                @if($filiere->description)
                    <p class="text-gray-500 mt-1">{{ $filiere->description }}</p>
                @endif
            </div>
            <div class="flex gap-2">
                <a href="{{ route('admin.filieres.edit', $filiere) }}" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                    Modifier
                </a>
                <a href="{{ route('admin.filieres.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                    Retour
                </a>
            </div>
        </div>
    </div>
</div>

@if(session('success'))
    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
        {{ session('success') }}
    </div>
@endif

@foreach($filiere->niveaux as $niveau)
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
    <div class="p-6">
        <div class="flex justify-between items-center mb-4 border-b pb-4">
            <h2 class="text-2xl font-bold text-gray-800">{{ $niveau->nom }}</h2>
            <span class="px-3 py-1 text-sm rounded-full {{ $niveau->statut ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                {{ $niveau->statut ? 'Actif' : 'Inactif' }}
            </span>
        </div>

        <!-- Frais -->
        <div class="mb-6">
            <div class="flex justify-between items-center mb-3">
                <h3 class="text-lg font-semibold text-gray-700">Frais / Pension</h3>
                <a href="{{ route('admin.frais.edit', $niveau) }}" class="text-indigo-600 hover:text-indigo-900 text-sm">Modifier les frais</a>
            </div>
            @if($niveau->frais)
                <div class="bg-gray-50 rounded-lg p-4">
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div>
                            <span class="text-sm text-gray-500">Total annuel</span>
                            <p class="font-bold text-lg">{{ number_format($niveau->frais->montant_total, 0, ',', ' ') }} FCFA</p>
                        </div>
                        @if($niveau->frais->frais_inscription)
                        <div>
                            <span class="text-sm text-gray-500">Frais inscription</span>
                            <p class="font-semibold">{{ number_format($niveau->frais->frais_inscription, 0, ',', ' ') }} FCFA</p>
                        </div>
                        @endif
                        @if($niveau->frais->tranche_1)
                        <div>
                            <span class="text-sm text-gray-500">Tranche 1</span>
                            <p class="font-semibold">{{ number_format($niveau->frais->tranche_1, 0, ',', ' ') }} FCFA</p>
                        </div>
                        @endif
                        @if($niveau->frais->tranche_2)
                        <div>
                            <span class="text-sm text-gray-500">Tranche 2</span>
                            <p class="font-semibold">{{ number_format($niveau->frais->tranche_2, 0, ',', ' ') }} FCFA</p>
                        </div>
                        @endif
                        @if($niveau->frais->tranche_3)
                        <div>
                            <span class="text-sm text-gray-500">Tranche 3</span>
                            <p class="font-semibold">{{ number_format($niveau->frais->tranche_3, 0, ',', ' ') }} FCFA</p>
                        </div>
                        @endif
                    </div>
                </div>
            @else
                <p class="text-gray-500 italic">Aucun frais defini - <a href="{{ route('admin.frais.edit', $niveau) }}" class="text-indigo-600">Configurer</a></p>
            @endif
        </div>

        <!-- Matieres -->
        <div class="mb-6">
            <div class="flex justify-between items-center mb-3">
                <h3 class="text-lg font-semibold text-gray-700">Matieres</h3>
                <a href="{{ route('admin.matieres.create', $niveau) }}" class="text-indigo-600 hover:text-indigo-900 text-sm">+ Ajouter une matiere</a>
            </div>
            @if($niveau->matieres->count() > 0)
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Matiere</th>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Coefficient</th>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Statut</th>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            @foreach($niveau->matieres->sortBy('ordre') as $matiere)
                            <tr>
                                <td class="px-4 py-2 text-sm">{{ $matiere->nom }}</td>
                                <td class="px-4 py-2 text-sm">{{ $matiere->coefficient }}</td>
                                <td class="px-4 py-2">
                                    <span class="px-2 text-xs rounded-full {{ $matiere->statut ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                        {{ $matiere->statut ? 'Actif' : 'Inactif' }}
                                    </span>
                                </td>
                                <td class="px-4 py-2 text-sm">
                                    <a href="{{ route('admin.matieres.edit', $matiere) }}" class="text-indigo-600 hover:text-indigo-900 mr-2">Modifier</a>
                                    <form action="{{ route('admin.matieres.destroy', $matiere) }}" method="POST" class="inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-red-600 hover:text-red-900" onclick="return confirm('Supprimer cette matiere ?')">Supprimer</button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-gray-500 italic">Aucune matiere definie</p>
            @endif
        </div>

        <!-- Documents requis -->
        <div>
            <div class="flex justify-between items-center mb-3">
                <h3 class="text-lg font-semibold text-gray-700">Documents requis</h3>
                <a href="{{ route('admin.documents-niveau.create', $niveau) }}" class="text-indigo-600 hover:text-indigo-900 text-sm">+ Ajouter un document</a>
            </div>
            @if($niveau->documentsNiveau->count() > 0)
                <ul class="space-y-2">
                    @foreach($niveau->documentsNiveau->sortBy('ordre') as $doc)
                    <li class="flex justify-between items-center bg-gray-50 rounded p-3">
                        <div>
                            <span class="font-medium">{{ $doc->intitule }}</span>
                            @if($doc->obligatoire)
                                <span class="ml-2 text-xs text-red-600">(Obligatoire)</span>
                            @endif
                            @if($doc->description)
                                <p class="text-sm text-gray-500">{{ $doc->description }}</p>
                            @endif
                        </div>
                        <div class="flex gap-2">
                            <a href="{{ route('admin.documents-niveau.edit', $doc) }}" class="text-indigo-600 hover:text-indigo-900 text-sm">Modifier</a>
                            <form action="{{ route('admin.documents-niveau.destroy', $doc) }}" method="POST" class="inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-900 text-sm" onclick="return confirm('Supprimer ce document ?')">Supprimer</button>
                            </form>
                        </div>
                    </li>
                    @endforeach
                </ul>
            @else
                <p class="text-gray-500 italic">Aucun document requis defini</p>
            @endif
        </div>
    </div>
</div>
@endforeach
@endsection
