@extends('layouts.admin')

@section('content')
<div class="max-w-3xl">
    <div class="mb-8">
        <div class="flex items-center gap-3 mb-3">
            <a href="{{ route('admin.filieres.index') }}" class="w-10 h-10 rounded-lg bg-slate-100 hover:bg-slate-200 flex items-center justify-center transition-colors">
                <svg class="w-5 h-5 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                </svg>
            </a>
            <div>
                <h1 class="text-3xl font-bold text-slate-900">Créer une filière</h1>
                <p class="text-slate-600 mt-1">Définissez une nouvelle filière avec ses niveaux</p>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-2xl shadow-md border border-slate-200 overflow-hidden">
        <form action="{{ route('admin.filieres.store') }}" method="POST">
            @csrf

            <div class="p-8 space-y-6">
                <!-- Nom de la filière -->
                <div>
                    <label for="nom" class="block text-sm font-semibold text-slate-700 mb-2">
                        Nom de la filière <span class="text-red-500">*</span>
                    </label>
                    <input
                        type="text"
                        name="nom"
                        id="nom"
                        value="{{ old('nom') }}"
                        placeholder="Ex: Comptabilité et Gestion, Informatique de Gestion..."
                        required
                        class="w-full px-4 py-3 rounded-xl border-2 border-slate-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all @error('nom') border-red-500 focus:border-red-500 focus:ring-red-500/10 @enderror"
                    >
                    @error('nom')
                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Description -->
                <div>
                    <label for="description" class="block text-sm font-semibold text-slate-700 mb-2">
                        Description
                        <span class="text-slate-400 font-normal">(optionnelle)</span>
                    </label>
                    <textarea
                        name="description"
                        id="description"
                        rows="4"
                        placeholder="Décrivez cette filière, ses objectifs et débouchés..."
                        class="w-full px-4 py-3 rounded-xl border-2 border-slate-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all resize-none @error('description') border-red-500 focus:border-red-500 focus:ring-red-500/10 @enderror"
                    >{{ old('description') }}</textarea>
                    @error('description')
                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Nombre de niveaux -->
                <div class="bg-gradient-to-br from-blue-50 to-indigo-50 rounded-xl p-6 border border-blue-100">
                    <label for="nombre_niveaux" class="block text-sm font-semibold text-slate-900 mb-3">
                        <span class="flex items-center gap-2">
                            <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                            </svg>
                            Nombre de niveaux <span class="text-red-500">*</span>
                        </span>
                    </label>
                    <select
                        name="nombre_niveaux"
                        id="nombre_niveaux"
                        required
                        class="w-full px-4 py-3 rounded-xl border-2 border-blue-200 bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all font-medium @error('nombre_niveaux') border-red-500 focus:border-red-500 focus:ring-red-500/10 @enderror"
                    >
                        <option value="1" {{ old('nombre_niveaux') == 1 ? 'selected' : '' }}>1 niveau (1 année)</option>
                        <option value="2" {{ old('nombre_niveaux', 2) == 2 ? 'selected' : '' }}>2 niveaux (2 années) - Recommandé pour BTS</option>
                        <option value="3" {{ old('nombre_niveaux') == 3 ? 'selected' : '' }}>3 niveaux (3 années) - Licence</option>
                    </select>
                    <p class="mt-3 text-sm text-slate-600 flex items-start gap-2">
                        <svg class="w-5 h-5 text-blue-500 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <span>Les niveaux seront créés automatiquement (Niveau 1, Niveau 2, etc.). Vous pourrez ensuite configurer les matières, frais et documents pour chaque niveau.</span>
                    </p>
                    @error('nombre_niveaux')
                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Ordre d'affichage -->
                <div>
                    <label for="ordre" class="block text-sm font-semibold text-slate-700 mb-2">
                        Ordre d'affichage
                        <span class="text-slate-400 font-normal">(optionnel)</span>
                    </label>
                    <input
                        type="number"
                        name="ordre"
                        id="ordre"
                        value="{{ old('ordre', 0) }}"
                        min="0"
                        placeholder="0"
                        class="w-full px-4 py-3 rounded-xl border-2 border-slate-200 focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all @error('ordre') border-red-500 focus:border-red-500 focus:ring-red-500/10 @enderror"
                    >
                    <p class="mt-2 text-sm text-slate-500">Plus le nombre est petit, plus la filière apparaît en haut de la liste</p>
                    @error('ordre')
                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Statut -->
                <div class="flex items-center gap-3 p-4 bg-slate-50 rounded-xl border border-slate-200">
                    <input
                        type="checkbox"
                        name="statut"
                        id="statut"
                        value="1"
                        {{ old('statut', true) ? 'checked' : '' }}
                        class="w-5 h-5 rounded border-slate-300 text-blue-600 focus:ring-4 focus:ring-blue-500/20 transition-all"
                    >
                    <label for="statut" class="flex-1 cursor-pointer">
                        <span class="block text-sm font-semibold text-slate-900">Filière active</span>
                        <span class="block text-xs text-slate-500 mt-0.5">La filière sera visible sur le site public</span>
                    </label>
                </div>
            </div>

            <!-- Footer avec actions -->
            <div class="px-8 py-5 bg-gradient-to-r from-slate-50 to-slate-100 border-t border-slate-200 flex items-center justify-between gap-4">
                <a href="{{ route('admin.filieres.index') }}" class="inline-flex items-center gap-2 px-5 py-2.5 text-slate-600 hover:text-slate-900 hover:bg-white rounded-lg font-medium transition-all border border-transparent hover:border-slate-200">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                    Annuler
                </a>
                <button type="submit" class="inline-flex items-center gap-2 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white font-semibold px-6 py-3 rounded-xl shadow-lg shadow-blue-500/30 hover:shadow-xl hover:shadow-blue-500/40 transition-all transform hover:-translate-y-0.5">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    Créer la filière
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
