@extends('layouts.admin')

@section('content')
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-6 text-gray-900">
        <!-- Header avec retour -->
        <div class="mb-6 flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold">Configuration de la filiere : {{ $filiere->nom }}</h1>
                <p class="text-gray-500 mt-1">Configurez les matieres, frais et documents pour chaque niveau</p>
            </div>
            <a href="{{ route('admin.filieres.index') }}" class="text-gray-600 hover:text-gray-900 flex items-center gap-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                Retour a la liste
            </a>
        </div>

        @if(session('success'))
            <div class="mb-6 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative">
                {{ session('success') }}
            </div>
        @endif

        <!-- Description de la filiere -->
        <div class="mb-8 p-6 bg-blue-50 rounded-lg border border-blue-200">
            <h3 class="text-lg font-semibold text-blue-900 mb-2">A propos de cette filiere</h3>
            @if($filiere->description)
                <p class="text-blue-800">{{ $filiere->description }}</p>
            @else
                <p class="text-blue-600 italic">Aucune description</p>
            @endif
            <a href="{{ route('admin.filieres.edit', $filiere) }}" class="inline-flex items-center gap-1 mt-3 text-blue-700 hover:text-blue-900 text-sm font-medium">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                </svg>
                Modifier les infos generales
            </a>
        </div>

        <!-- Liste des niveaux -->
        <div class="space-y-8">
            @foreach($filiere->niveaux as $index => $niveau)
                <div class="border-2 {{ $index === 0 ? 'border-emerald-300' : ($index === 1 ? 'border-amber-300' : 'border-purple-300') }} rounded-xl overflow-hidden">
                    <!-- Header du niveau -->
                    <div class="bg-gradient-to-r {{ $index === 0 ? 'from-emerald-500 to-emerald-600' : ($index === 1 ? 'from-amber-500 to-amber-600' : 'from-purple-500 to-purple-600') }} p-6">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-12 h-12 bg-white/20 backdrop-blur-sm rounded-full flex items-center justify-center border-2 border-white/40">
                                    <span class="text-white font-bold text-xl">{{ $index + 1 }}</span>
                                </div>
                                <div>
                                    <h2 class="text-2xl font-bold text-white">{{ $niveau->nom }}</h2>
                                    <p class="text-white/80 text-sm">{{ $index === 0 ? 'Premiere annee' : ($index === 1 ? 'Deuxieme annee' : 'Annee ' . ($index + 1)) }}</p>
                                </div>
                            </div>
                            <a href="{{ route('admin.niveaux.edit', $niveau) }}" class="bg-white/20 hover:bg-white/30 text-white px-4 py-2 rounded-lg text-sm font-medium transition">
                                Modifier le nom
                            </a>
                        </div>
                    </div>

                    <div class="p-6 bg-gray-50">
                        <div class="grid md:grid-cols-3 gap-6">

                            <!-- Section Frais -->
                            <div class="bg-white rounded-lg p-5 border border-gray-200">
                                <div class="flex items-center justify-between mb-4">
                                    <h3 class="text-lg font-bold text-gray-900 flex items-center gap-2">
                                        <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                        </svg>
                                        Frais academiques
                                    </h3>
                                </div>

                                @if($niveau->frais)
                                    <div class="space-y-3 mb-4">
                                        <div class="flex justify-between items-center pb-2 border-b">
                                            <span class="text-sm text-gray-600">Pension totale</span>
                                            <span class="font-bold text-gray-900">{{ number_format($niveau->frais->montant_total, 0, ',', ' ') }} FCFA</span>
                                        </div>
                                        @if($niveau->frais->frais_inscription > 0)
                                        <div class="flex justify-between items-center pb-2 border-b">
                                            <span class="text-sm text-gray-600">Frais d'inscription</span>
                                            <span class="font-bold text-gray-900">{{ number_format($niveau->frais->frais_inscription, 0, ',', ' ') }} FCFA</span>
                                        </div>
                                        @endif
                                        @if($niveau->frais->tranche_1 || $niveau->frais->tranche_2 || $niveau->frais->tranche_3)
                                        <div class="pt-2">
                                            <p class="text-xs font-semibold text-gray-500 uppercase mb-2">Paiement echelonne</p>
                                            <div class="space-y-1">
                                                @if($niveau->frais->tranche_1)
                                                <div class="flex justify-between text-sm">
                                                    <span class="text-gray-600">Tranche 1</span>
                                                    <span class="font-medium">{{ number_format($niveau->frais->tranche_1, 0, ',', ' ') }}</span>
                                                </div>
                                                @endif
                                                @if($niveau->frais->tranche_2)
                                                <div class="flex justify-between text-sm">
                                                    <span class="text-gray-600">Tranche 2</span>
                                                    <span class="font-medium">{{ number_format($niveau->frais->tranche_2, 0, ',', ' ') }}</span>
                                                </div>
                                                @endif
                                                @if($niveau->frais->tranche_3)
                                                <div class="flex justify-between text-sm">
                                                    <span class="text-gray-600">Tranche 3</span>
                                                    <span class="font-medium">{{ number_format($niveau->frais->tranche_3, 0, ',', ' ') }}</span>
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                    <a href="{{ route('admin.frais.edit', $niveau) }}" class="block w-full text-center bg-green-600 hover:bg-green-700 text-white py-2 px-4 rounded-lg text-sm font-medium transition">
                                        Modifier les frais
                                    </a>
                                @else
                                    <p class="text-gray-500 text-sm mb-4 italic">Aucun frais configure</p>
                                    <a href="{{ route('admin.frais.edit', $niveau) }}" class="block w-full text-center bg-green-600 hover:bg-green-700 text-white py-2 px-4 rounded-lg text-sm font-medium transition">
                                        Configurer les frais
                                    </a>
                                @endif
                            </div>

                            <!-- Section Matieres -->
                            <div class="bg-white rounded-lg p-5 border border-gray-200">
                                <div class="flex items-center justify-between mb-4">
                                    <h3 class="text-lg font-bold text-gray-900 flex items-center gap-2">
                                        <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                                        </svg>
                                        Matieres
                                        <span class="ml-auto text-xs bg-blue-100 text-blue-800 px-2 py-1 rounded-full font-medium">{{ $niveau->matieres->count() }}</span>
                                    </h3>
                                </div>

                                @if($niveau->matieres->count() > 0)
                                    <div class="space-y-2 mb-4 max-h-48 overflow-y-auto">
                                        @foreach($niveau->matieres as $matiere)
                                            <div class="flex items-center justify-between p-2 bg-gray-50 rounded border border-gray-200">
                                                <span class="text-sm text-gray-800">{{ $matiere->nom }}</span>
                                                <div class="flex items-center gap-2">
                                                    <span class="text-xs bg-blue-100 text-blue-800 px-2 py-1 rounded">Coef. {{ $matiere->coefficient }}</span>
                                                    <a href="{{ route('admin.matieres.edit', $matiere) }}" class="text-blue-600 hover:text-blue-800">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                                        </svg>
                                                    </a>
                                                    <form action="{{ route('admin.matieres.destroy', $matiere) }}" method="POST" class="inline" onsubmit="return confirm('Supprimer cette matiere ?');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="text-red-600 hover:text-red-800">
                                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                                            </svg>
                                                        </button>
                                                    </form>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <p class="text-gray-500 text-sm mb-4 italic">Aucune matiere</p>
                                @endif

                                <a href="{{ route('admin.matieres.create', $niveau) }}" class="block w-full text-center bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded-lg text-sm font-medium transition">
                                    + Ajouter une matiere
                                </a>
                            </div>

                            <!-- Section Documents -->
                            <div class="bg-white rounded-lg p-5 border border-gray-200">
                                <div class="flex items-center justify-between mb-4">
                                    <h3 class="text-lg font-bold text-gray-900 flex items-center gap-2">
                                        <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                        </svg>
                                        Documents
                                        <span class="ml-auto text-xs bg-purple-100 text-purple-800 px-2 py-1 rounded-full font-medium">{{ $niveau->documentsNiveau->count() }}</span>
                                    </h3>
                                </div>

                                @if($niveau->documentsNiveau->count() > 0)
                                    <div class="space-y-2 mb-4 max-h-48 overflow-y-auto">
                                        @foreach($niveau->documentsNiveau as $doc)
                                            <div class="flex items-start justify-between p-2 bg-gray-50 rounded border border-gray-200">
                                                <div class="flex items-start gap-2 flex-1">
                                                    <svg class="w-4 h-4 {{ $doc->obligatoire ? 'text-red-500' : 'text-green-500' }} mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $doc->obligatoire ? 'M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z' : 'M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z' }}"/>
                                                    </svg>
                                                    <span class="text-sm text-gray-800">{{ $doc->intitule }}</span>
                                                </div>
                                                <div class="flex items-center gap-2">
                                                    <a href="{{ route('admin.documents-niveau.edit', $doc) }}" class="text-purple-600 hover:text-purple-800">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                                        </svg>
                                                    </a>
                                                    <form action="{{ route('admin.documents-niveau.destroy', $doc) }}" method="POST" class="inline" onsubmit="return confirm('Supprimer ce document ?');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="text-red-600 hover:text-red-800">
                                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                                            </svg>
                                                        </button>
                                                    </form>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <p class="text-gray-500 text-sm mb-4 italic">Aucun document</p>
                                @endif

                                <a href="{{ route('admin.documents-niveau.create', $niveau) }}" class="block w-full text-center bg-purple-600 hover:bg-purple-700 text-white py-2 px-4 rounded-lg text-sm font-medium transition">
                                    + Ajouter un document
                                </a>
                            </div>

                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Actions finales -->
        <div class="mt-8 flex items-center justify-between p-6 bg-gray-100 rounded-lg">
            <div>
                <h3 class="font-bold text-gray-900">Configuration terminee ?</h3>
                <p class="text-sm text-gray-600">Verifiez que tous les niveaux sont bien configures avant de quitter.</p>
            </div>
            <a href="{{ route('admin.filieres.index') }}" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-3 px-6 rounded-lg transition">
                Terminer et retourner a la liste
            </a>
        </div>
    </div>
</div>
@endsection
