<?php

namespace Database\Seeders;

use App\Models\Faq;
use Illuminate\Database\Seeder;

class FaqSeeder extends Seeder
{
    public function run(): void
    {
        $faqs = [
            [
                'question' => "Comment s'inscrire a ISTMAD ?",
                'reponse' => "Vous pouvez vous inscrire en ligne via notre formulaire d'inscription ou vous rendre directement dans nos locaux avec les documents requis.",
                'actif' => true,
                'ordre' => 1,
            ],
            [
                'question' => 'Quels sont les documents necessaires ?',
                'reponse' => "Photocopie du BAC, CNI ou acte de naissance, 4 photos d'identite et les frais d'inscription.",
                'actif' => true,
                'ordre' => 2,
            ],
            [
                'question' => 'Proposez-vous des facilites de paiement ?',
                'reponse' => 'Oui, nous offrons des possibilites de paiement echelonne. Contactez-nous pour en savoir plus sur les modalites.',
                'actif' => true,
                'ordre' => 3,
            ],
        ];

        foreach ($faqs as $faq) {
            Faq::create($faq);
        }
    }
}
