<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->string('annee_academique')->default('2025-2026')->after('mail_enabled');
            $table->boolean('inscriptions_ouvertes')->default(true)->after('annee_academique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn(['annee_academique', 'inscriptions_ouvertes']);
        });
    }
};
