<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
        'mail_mailer',
        'mail_host',
        'mail_port',
        'mail_username',
        'mail_password',
        'mail_encryption',
        'mail_from_address',
        'mail_from_name',
        'mail_enabled',
        'annee_academique',
        'inscriptions_ouvertes',
    ];

    protected $casts = [
        'mail_enabled' => 'boolean',
        'inscriptions_ouvertes' => 'boolean',
    ];

    public static function getMailSettings(): ?self
    {
        return self::first();
    }

    public static function isMailEnabled(): bool
    {
        $settings = self::first();
        return $settings && $settings->mail_enabled;
    }
}
