<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Frais extends Model
{
    use HasFactory;

    protected $table = 'frais';

    protected $fillable = [
        'niveau_id',
        'montant_total',
        'tranche_1',
        'tranche_2',
        'tranche_3',
        'frais_inscription',
    ];

    protected $casts = [
        'montant_total' => 'decimal:2',
        'tranche_1' => 'decimal:2',
        'tranche_2' => 'decimal:2',
        'tranche_3' => 'decimal:2',
        'frais_inscription' => 'decimal:2',
    ];

    public function niveau()
    {
        return $this->belongsTo(Niveau::class);
    }
}
