<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DocumentNiveau extends Model
{
    use HasFactory;

    protected $table = 'documents_niveau';

    protected $fillable = [
        'niveau_id',
        'intitule',
        'description',
        'obligatoire',
        'ordre',
    ];

    protected $casts = [
        'obligatoire' => 'boolean',
    ];

    public function niveau()
    {
        return $this->belongsTo(Niveau::class);
    }

    public function scopeOrdre($query)
    {
        return $query->orderBy('ordre', 'asc');
    }
}
