<?php

namespace App\Mail;

use App\Models\Message;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ReponseMessage extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Message $messageOriginal,
        public string $reponse
    ) {}

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Re: ' . $this->messageOriginal->sujet,
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.reponse-message',
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
