<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Mail\ReponseMessage;
use App\Models\Message;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class MessageController extends Controller
{
    public function index()
    {
        $messages = Message::latest()->get();
        return view('admin.messages.index', compact('messages'));
    }

    public function show(Message $message)
    {
        $mailEnabled = Setting::isMailEnabled();
        return view('admin.messages.show', compact('message', 'mailEnabled'));
    }

    public function repondre(Request $request, Message $message)
    {
        if (!Setting::isMailEnabled()) {
            return redirect()->route('admin.messages.show', $message)
                ->with('error', 'L\'envoi d\'emails est desactive. Veuillez configurer les parametres email.');
        }

        $validated = $request->validate([
            'reponse' => 'required|string|max:5000',
        ]);

        try {
            Mail::to($message->email)->send(new ReponseMessage($message, $validated['reponse']));
            $message->update(['lu' => true]);
            return redirect()->route('admin.messages.show', $message)->with('success', 'Reponse envoyee avec succes.');
        } catch (\Exception $e) {
            return redirect()->route('admin.messages.show', $message)
                ->with('error', 'Erreur lors de l\'envoi de l\'email. Verifiez la configuration SMTP.');
        }
    }
}
