<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Inscription;
use Illuminate\Http\Request;

class InscriptionController extends Controller
{
    public function index()
    {
        $inscriptions = Inscription::with(['filiere', 'niveau'])->latest()->get();
        return view('admin.inscriptions.index', compact('inscriptions'));
    }

    public function show(Inscription $inscription)
    {
        $inscription->load(['filiere', 'niveau']);
        return view('admin.inscriptions.show', compact('inscription'));
    }

    public function updateStatut(Request $request, Inscription $inscription)
    {
        $validated = $request->validate([
            'statut' => 'required|in:nouvelle,traitee,rejetee',
        ]);

        $inscription->update($validated);

        return redirect()->route('admin.inscriptions.show', $inscription)->with('success', 'Statut mis à jour avec succès.');
    }
}
