<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DocumentRequis;
use Illuminate\Http\Request;

class DocumentRequisController extends Controller
{
    public function index()
    {
        $documents = DocumentRequis::ordre()->get();
        return view('admin.documents.index', compact('documents'));
    }

    public function create()
    {
        return view('admin.documents.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'intitule' => 'required|string|max:255',
            'description' => 'nullable|string',
            'actif' => 'boolean',
            'ordre' => 'nullable|integer',
        ]);

        $validated['actif'] = $request->has('actif');
        $validated['ordre'] = $validated['ordre'] ?? DocumentRequis::max('ordre') + 1;

        DocumentRequis::create($validated);

        return redirect()->route('admin.documents.index')
            ->with('success', 'Document requis ajouté avec succès.');
    }

    public function edit(DocumentRequis $document)
    {
        return view('admin.documents.edit', compact('document'));
    }

    public function update(Request $request, DocumentRequis $document)
    {
        $validated = $request->validate([
            'intitule' => 'required|string|max:255',
            'description' => 'nullable|string',
            'actif' => 'boolean',
            'ordre' => 'nullable|integer',
        ]);

        $validated['actif'] = $request->has('actif');

        $document->update($validated);

        return redirect()->route('admin.documents.index')
            ->with('success', 'Document requis mis à jour avec succès.');
    }

    public function destroy(DocumentRequis $document)
    {
        $document->delete();

        return redirect()->route('admin.documents.index')
            ->with('success', 'Document requis supprimé avec succès.');
    }
}
