<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Filiere;
use App\Models\Inscription;
use App\Models\Message;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        // Statistiques pour les cartes du dashboard
        $stats = [
            'total_filieres' => Filiere::count(),
            'total_inscriptions' => Inscription::count(),
            'inscriptions_en_attente' => Inscription::where('statut', 'nouvelle')->count(),
            'total_messages' => Message::count(),
            'messages_non_lus' => Message::where('lu', false)->count(),
        ];

        // Dernières inscriptions
        $dernieres_inscriptions = Inscription::with(['filiere', 'niveau'])
            ->orderBy('created_at', 'desc')
            ->take(5)
            ->get();

        // Derniers messages
        $derniers_messages = Message::orderBy('created_at', 'desc')
            ->take(5)
            ->get();

        return view('admin.dashboard', compact('stats', 'dernieres_inscriptions', 'derniers_messages'));
    }
}
